/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import cloud.lemonslice.teastory.client.container.DrinkMakerContainer;
import cloud.lemonslice.teastory.recipe.drink.DrinkRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import xueluoanping.teastory.block.entity.NormalContainerBlockEntity;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.craft.MultiRecipeWrapper;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.RecipeRegister;

public class DrinkMakerBlockEntity
extends NormalContainerBlockEntity {
    private final LazyOptional<ItemStackHandler> ingredientsInventory = LazyOptional.of(() -> this.createItemHandler(4));
    private final LazyOptional<ItemStackHandler> residuesInventory = LazyOptional.of(() -> this.createItemHandler(4));
    private final LazyOptional<ItemStackHandler> containerInventory = LazyOptional.of(() -> this.createContainerItemHandler(1));
    private final LazyOptional<ItemStackHandler> inputInventory = LazyOptional.of(() -> this.createItemHandler(1));
    private final LazyOptional<ItemStackHandler> outputInventory = LazyOptional.of(() -> this.createContainerItemHandler(1));
    private int processTicks = 0;
    private static final int totalTicks = 200;
    private DrinkRecipe currentRecipe;

    public DrinkMakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.DRINK_MAKER_TYPE.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.m_58901_()) {
            if (ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
                if (side == Direction.DOWN) {
                    return this.residuesInventory.cast();
                }
                return this.ingredientsInventory.cast();
            }
            if (ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
                return this.getFluidHandler().cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ingredientsInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Ingredients")));
        this.residuesInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Residues")));
        this.containerInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Container")));
        this.inputInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Input")));
        this.outputInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Output")));
        this.processTicks = tag.m_128451_("ProcessTicks");
    }

    protected void m_183515_(CompoundTag tag) {
        this.ingredientsInventory.ifPresent(h -> tag.m_128365_("Ingredients", h.serializeNBT()));
        this.residuesInventory.ifPresent(h -> tag.m_128365_("Residues", h.serializeNBT()));
        this.containerInventory.ifPresent(h -> tag.m_128365_("Container", h.serializeNBT()));
        this.inputInventory.ifPresent(h -> tag.m_128365_("Input", h.serializeNBT()));
        this.outputInventory.ifPresent(h -> tag.m_128365_("Output", h.serializeNBT()));
        tag.m_128405_("ProcessTicks", this.processTicks);
        super.m_183515_(tag);
    }

    private boolean isEnoughAmount() {
        if (this.currentRecipe != null) {
            int n = (int)Math.ceil(1.0f * (float)this.getFluidAmount() / (float)this.currentRecipe.getFluidAmount());
            for (int i = 0; i < 4; ++i) {
                if (this.getStackInSlot(i).m_41619_() || this.getStackInSlot(i).m_41613_() >= n) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void tick(Level worldIn, BlockPos pos, BlockState blockState, DrinkMakerBlockEntity tileEntity) {
        if (tileEntity.getFluidAmount() != 0 && !tileEntity.isIngredientsEmpty()) {
            MultiRecipeWrapper warp = new MultiRecipeWrapper((ItemStackHandler)tileEntity.ingredientsInventory.resolve().get(), (ItemStackHandler)tileEntity.residuesInventory.resolve().get(), (ItemStackHandler)tileEntity.containerInventory.resolve().get());
            if (tileEntity.currentRecipe == null || !tileEntity.currentRecipe.matches(warp, worldIn)) {
                tileEntity.currentRecipe = worldIn.m_7465_().m_44015_((RecipeType)RecipeRegister.DRINK_MAKER.get(), (Container)warp, worldIn).orElse(null);
            }
            if (tileEntity.currentRecipe != null && tileEntity.isEnoughAmount()) {
                ++tileEntity.processTicks;
                tileEntity.inventoryChanged();
                if (tileEntity.processTicks >= 200 && tileEntity.ingredientsInventory.resolve().isPresent()) {
                    ItemStackHandler inv = (ItemStackHandler)tileEntity.ingredientsInventory.resolve().get();
                    if (tileEntity.getFluidHandler().resolve().isPresent()) {
                        IFluidHandlerItem fluid2 = (IFluidHandlerItem)tileEntity.getFluidHandler().resolve().get();
                        if (tileEntity.residuesInventory.resolve().isPresent()) {
                            ItemStackHandler h = (ItemStackHandler)tileEntity.residuesInventory.resolve().get();
                            int n = (int)Math.ceil((float)tileEntity.getFluidAmount() * 1.0f / (float)tileEntity.currentRecipe.getFluidIngredient().getMatchingFluidStacks().get(0).getAmount());
                            for (int i = 0; i < 4; ++i) {
                                ItemStack residue = inv.getStackInSlot(i).getCraftingRemainingItem();
                                inv.extractItem(i, n, false);
                                if (residue.m_41619_()) continue;
                                residue.m_41764_(n);
                                h.insertItem(i, residue, false);
                            }
                        }
                        if (tileEntity.containerInventory.resolve().isPresent()) {
                            CompoundTag nbt = new FluidStack(tileEntity.currentRecipe.getFluidResult(), tileEntity.getFluidAmount()).writeToNBT(new CompoundTag());
                            fluid2.getContainer().m_41784_().m_128365_("Fluid", (Tag)nbt);
                        }
                        tileEntity.setToZero();
                    }
                }
            } else {
                tileEntity.setToZero();
            }
        } else {
            tileEntity.currentRecipe = null;
            tileEntity.setToZero();
        }
        tileEntity.getFluidHandler().ifPresent(fluid -> tileEntity.inputInventory.ifPresent(in -> tileEntity.outputInventory.ifPresent(out -> {
            ItemStack inputCup = ItemHandlerHelper.copyStackWithSize((ItemStack)in.getStackInSlot(0), (int)1);
            ItemStack outputCup = out.getStackInSlot(0);
            if (outputCup.m_41619_()) {
                FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)inputCup, (IFluidHandler)fluid, (IItemHandler)out, (int)Integer.MAX_VALUE, null, (boolean)true);
                if (!fluidActionResult.isSuccess()) {
                    fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)inputCup, (IFluidHandler)fluid, (IItemHandler)out, (int)Integer.MAX_VALUE, null, (boolean)true);
                }
                if (fluidActionResult.isSuccess()) {
                    out.setStackInSlot(0, fluidActionResult.getResult());
                    in.getStackInSlot(0).m_41774_(1);
                }
                if (fluid.getFluidInTank(0).isEmpty()) {
                    tileEntity.containerInventory.ifPresent(container -> {
                        if (container.getStackInSlot(0).hasCraftingRemainingItem()) {
                            container.setStackInSlot(0, container.getStackInSlot(0).getCraftingRemainingItem());
                        }
                    });
                }
            }
        })));
    }

    private ItemStackHandler createItemHandler(int size) {
        return new SyncedBlockEntity.SyncedItemStackHandler(this, size);
    }

    private ItemStackHandler createContainerItemHandler(int size) {
        return new SyncedBlockEntity.SyncedItemStackHandler(size){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !(stack.m_41720_() instanceof BucketItem);
            }
        };
    }

    private void setToZero() {
        if (this.processTicks != 0) {
            this.processTicks = 0;
            this.m_6596_();
        }
    }

    public int getProcessTicks() {
        return this.processTicks;
    }

    public int getTotalTicks() {
        return 200;
    }

    public int getFluidAmount() {
        return this.getFluidHandler().map(h -> h.getFluidInTank(0).getAmount()).orElse(0);
    }

    @Nullable
    public DrinkRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public int getNeededAmount() {
        if (this.currentRecipe != null) {
            return (int)Math.ceil((float)this.getFluidAmount() * 1.0f / (float)this.currentRecipe.getFluidIngredient().getMatchingFluidStacks().get(0).getAmount());
        }
        return 0;
    }

    @Nullable
    public Component getFluidTranslation() {
        return this.getFluidHandler().map(h -> h.getFluidInTank(0).getDisplayName()).orElse(null);
    }

    public LazyOptional<IFluidHandlerItem> getFluidHandler() {
        return this.containerInventory.map(h -> FluidUtil.getFluidHandler((ItemStack)h.getStackInSlot(0))).orElse(LazyOptional.empty());
    }

    public LazyOptional<ItemStackHandler> getContainerInventory() {
        return this.containerInventory;
    }

    public LazyOptional<ItemStackHandler> getInputInventory() {
        return this.inputInventory;
    }

    public LazyOptional<ItemStackHandler> getOutputInventory() {
        return this.outputInventory;
    }

    public List<ItemStack> getContent() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int i = 0;
        while (i < 4) {
            int index = i++;
            this.ingredientsInventory.ifPresent(h -> list.add(h.getStackInSlot(index)));
        }
        this.containerInventory.ifPresent(h -> list.add(h.getStackInSlot(0)));
        return list;
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    }

    public boolean isIngredientsEmpty() {
        return this.ingredientsInventory.map(h -> {
            for (int i = 0; i < 4; ++i) {
                if (h.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    public boolean isEmpty() {
        return this.isIngredientsEmpty() && this.residuesInventory.map(h -> {
            for (int i = 0; i < 4; ++i) {
                if (h.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }).orElse(true) != false && this.containerInventory.map(h -> h.getStackInSlot(0).m_41619_()).orElse(true) != false && this.inputInventory.map(h -> h.getStackInSlot(0).m_41619_()).orElse(true) != false && this.outputInventory.map(h -> h.getStackInSlot(0).m_41619_()).orElse(true) != false;
    }

    public ItemStack getStackInSlot(int index) {
        if (index < 4) {
            return this.ingredientsInventory.map(h -> h.getStackInSlot(index)).orElse(ItemStack.f_41583_);
        }
        if (index < 8) {
            return this.residuesInventory.map(h -> h.getStackInSlot(index - 4)).orElse(ItemStack.f_41583_);
        }
        if (index == 8) {
            return this.containerInventory.map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        }
        if (index == 9) {
            return this.inputInventory.map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        }
        return this.outputInventory.map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
    }

    public ItemStack decrStackSize(int index, int count) {
        if (index < 4) {
            return this.ingredientsInventory.map(h -> h.getStackInSlot(index).m_41620_(count)).orElse(ItemStack.f_41583_);
        }
        if (index < 8) {
            return this.residuesInventory.map(h -> h.getStackInSlot(index - 4).m_41620_(count)).orElse(ItemStack.f_41583_);
        }
        if (index == 8) {
            return this.containerInventory.map(h -> h.getStackInSlot(0).m_41620_(count)).orElse(ItemStack.f_41583_);
        }
        if (index == 9) {
            return this.inputInventory.map(h -> h.getStackInSlot(0).m_41620_(count)).orElse(ItemStack.f_41583_);
        }
        return this.outputInventory.map(h -> h.getStackInSlot(0).m_41620_(count)).orElse(ItemStack.f_41583_);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p_39956_) {
        return new DrinkMakerContainer(id, playerInventory, this.f_58858_, this.f_58857_);
    }
}

